<?php

define("SECUOTP_ERROR_ALLOCHANDLE_FAILED", 11);	//alloc ODBC handle failed
define("SECUOTP_ERROR_FREEHANDLE_FAILED", 12);	//release ODBC handle failed
define("SECUOTP_ERROR_SETENVATTR_FAILED", 13);	//set environment for ODBC failed
define("SECUOTP_ERROR_GETCONFIGFAILED", 14);	//get arguments for connecting ODBC failed
define("SECUOTP_ERROR_CONNECTDBFAILED", 15); //connect to database failed
define("SECUOTP_ERROR_SQLEXFAILED", 16);	//SQL Statement execute failed
define("SECUOTP_ERROR_NORELATEITEM", 17); //no relate item
define("SECUOTP_ERROR_GETUSERINFO_FAILED", 18);//get user information failed
define("SECUOTP_ERROR_USERREGLOST", 19);				//user registe lost
define("SECUOTP_ERROR_USERLOCKED", 20);			//user is locked
define("SECUOTP_ERROR_UNLOCK_FAILED", 21);	//unlock user failed
define("SECUOTP_ERROR_UPDATEUSEDATE_FAILED", 22); //update operation time failed
define("SECUOTP_ERROR_UNKNOWNTKTYPE", 23);		//unknown token type
define("SECUOTP_ERROR_UPCHALLENG_FAILED", 24);	//update challenge number failed
define("SECUOTP_ERROR_INVALID_PASSWORD", 25);		//invalid password
define("SECUOTP_ERROR_SYNCHRONIZE_FAILED", 26);	//token synchronize  failed
define("SECUOTP_ERROR_INVALID_OLDPWD", 27);			//invalid old pin
define("SECUOTP_ERROR_INVALID_AUTHTYPE", 28);		//invalid authentication type
define("SECUOTP_ERROR_USEREXIST", 29);					//user exists
define("SECUOTP_ERROR_INVALID_TOKEN", 30);			//invalid token
define("SECUOTP_ERROR_INVALID_PARAM", 31);			//invalid parameters
define("SECUOTP_ERROR_ADDUSER_FAILED", 32);		//add user failed
define("SECUOTP_ERROR_UPDATETOKEN_FAILED", 33);	//update token failed
define("SECUOTP_ERROR_DELETETOKEN_FAILED", 34);		//delete token failed
define("SECUOTP_ERROR_GETTOKENSTATE_FAILED", 35);	//get token status failed
define("SECUOTP_ERROR_TOKENINUSE", 36);			//token inn using
define("SECUOTP_ERROR_INVALIDKEY", 37);			//invalid secret
define("SECUOTP_ERROR_OPENTOKENFILE_FAILED", 38);	//open token file failed
define("SECUOTP_ERROR_AESMKKEY_FAILED", 39);	//aes make key failed
define("SECUOTP_ERROR_AESDECRYPT_FAILED", 40);	//decrypt file failed
define("SECUOTP_ERROR_AESGETPLAIN_FAILED", 41);		//get plain failed
define("SECUOTP_ERROR_AUTHSUCCESS_WITHINFO", 42); //auth succeed with info
define("SECUOTP_ERROR_UPDATEKEYINFO_FAILED", 43); //update user secret failed
define("SECUOTP_ERROR_NOTNEEDSYNCHRONIZE", 44);		//challenge-response based token
define("SECUOTP_ERROR_SETUSERPIN_FAILED", 45);		//set pin for user failed
define("SECUOTP_ERROR_UPDATEPIN_FAILED", 46);		//update usr pin failed
define("SECUOTP_ERROR_SUCCESS_WITHINFO", 47);		//partble succeed
define("SECUOTP_ERROR_OPENUSERFILE_FAILED", 48);	//open userinformation file failed
define("SECUOTP_ERROR_GETFILESIZE_FAILED", 49);		//get file size failed

define("SECUOTP_ERROR_SRVIPNULL", 50);//authentication server ip need
define("SECUOTP_ERROR_GETERRINFOBUF_FAILED", 51);	//malloc function failed
define("SECUOTP_ERROR_GETFILECONT_FAILED", 52);	//get file content failed
define("SECUOTP_ERROR_UPDATEUSERBINDINFO_FAILED", 53);	//user rebind failed for reset user's token infomation failed
define("SECUOTP_ERROR_UPDATENEWTKSTATE_FAILED", 54);		//bind new token for user failed
define("SECUOTP_ERROR_INVALIDLOGLEV", 55);		//operator level invalid

define("SECUOTP_ERROR_CHALLENGE", 100);//challenge response
define("SECUOTP_ERROR_ALLOCMEM_FAILED", 101);
#define SECUOTP_ERROR_SUCCESS_WITHINFO		47 //error information return
#define SECUOTP_ERROR_OPENUSERFILE_FAILED	48 //open userinformation file failed
#define SECUOTP_ERROR_GETFILESIZE_FAILED	49 //get file size failed

#define SECUOTP_ERROR_SRVIPNULL				50	//authentication server ip need
#define SECUOTP_ERROR_GETERRINFOBUF_FAILED	51	//malloc function failed

#define SECUOTP_ERROR_GETFILECONT_FAILED	52	//get file content failed

#define SECUOTP_ERROR_UPDATEUSERBINDINFO_FAILED	53 //user rebind failed for reset user's token infomation failed
#define SECUOTP_ERROR_UPDATENEWTKSTATE_FAILED	54 //update new token for user failed
#define SECUOTP_ERROR_CHALLENGE				100 //the server should send a challenge number to the client
#define SECUOTP_ERROR_ALLOCMEM_FAILED		101

$secuotp_errinfo = array(
								"11" => "alloc ODBC handle failed.",
								"12" =>	"release ODBC handle failed.",
								"13" => "Init environment ODBC connecting failed.",
								"14" => "get arguments for ODBC connecting failed.",
								"15" => "cannot connect to the database.",
								"16" => "SQL statement executes failed.",
								"17" => "no related record.",
								"18" => "get user information failed.",
								"19" => "user has registed lost.",
								"20" => "user has been locked.",
								"21" => "failed in setting user unlock.",
								"22" => "update operation time failed.",
								"23" => "unknown token type.",
								"24" => "update challenge number failed.",
								"25" => "invalid password.",
								"26" => "token synchronize failed.",
								"27" => "invalid old user PIN.",
								"28" => "invalid authentication type.",
								"29" => "user exists.",
								"30" => "invlaid token.",
								"31" => "invalid parameters.",
								"32" => "add user failed.",
								"33" => "update token status failed.",
								"34" => "delete token failed.",
								"35" => "get token status failed.",
								"36" => "token is in using status.",
								"37" => "invalid secret.",
								"38" => "failed in opening token file.",
								"39" => "aes make key failed.",
								"40" => "decrypt file failed.",
								"41" => "get plain text failed.",
								"42" => "authentication succeed with info",
								"43" => "update user secret information failed.",
								"44" => "no synchronize needed for Challenge-Response based token ",
								"45" => "set pin for user failed.",
								"46" => "update user pin failed.",
								"47" => "partly success, with a error information return.",
								"48" => "failed in openning user information file.",
								"49" => "get file size failed.",
								"50" => "authentication server ip need.",
								"51" => "malloc function not executed succeed",
								"52" => "get file content failed.",
								"53" => "user rebind failed for reset user's token infomation failed",
								"54" => "reset token for user failed.",
								"55" => "invalid log level",
								"100" => "challenge request from authentication server.",
								"101" => "realloc memory failed."
);

function ErrorCode2Msg($index)
{
	global $secuotp_errinfo;
	if(!@isset($secuotp_errinfo["$index"]))
	{
		return "";	
	}
	return $secuotp_errinfo["$index"];
}
?>